# -*- coding: utf-8 -*-

from pytube import Playlist, YouTube
import re
import sys
import pydub
from pydub import AudioSegment
import simpleaudio as sa

def show_warning(message):
    print(message)

def is_valid_youtube_url(url):
    # YouTube video veya oynatma listesi URL'sini tanımlayan desen
    youtube_video_pattern = re.compile(r'https?://(www\.)?(youtube|youtu|youtube-nocookie)\.(com|be)/.*[^\w-]')
    youtube_playlist_pattern = re.compile(r'https?://(www\.)?(youtube|youtu|youtube-nocookie)\.(com|be)/playlist\?list=[^\w-]')

    # /@ ifadesini kontrol et
    invalid_channel_pattern = re.compile(r'https?://(www\.)?(youtube|youtu|youtube-nocookie)\.(com|be)/@.*')

    if bool(re.search(invalid_channel_pattern, url)):
        show_warning("Kanal indirmesi desteklenmemektedir.")
        return False

    if not re.match(r'https?://(www\.)?(youtube|youtu|youtube-nocookie)\.(com|be)', url):
        show_warning("Kafana göre rastgele tuşlara basma ulan! "
                     "Geçerli bir YouTube URL'si gir. Ha bu arada: "
                     "Bu uygulama YouTube kanallarını indirmeyi desteklemez. "
                     "YouTube kanalı indirmek istiyorsan azıcık para ver, çok daha işlevsel olan "
                     "4K Video Downloader yazılımını kullan.")
        return False

    is_valid_video = bool(re.match(youtube_video_pattern, url))
    is_valid_playlist = bool(re.match(youtube_playlist_pattern, url))

    if not is_valid_video and not is_valid_playlist:
        show_warning("Rast gele tuşlara basmayın ve geçerli bir YouTube URL'si girin. "
                     "Not: Bu uygulama YouTube kanallarını indirmeyi desteklememektedir.")
        return False

    return True

def get_user_input():
    play_welcome_sound()  # Hoş geldiniz sesini çal

    while True:
        media_url = input("İndirmek istediğin zıkkımın (video ya da oynatma listesi) URL'sini gir: ")

        if media_url.lower() == 'q':
            play_exit_sound()  # Çıkış sesini çal
            print("Sömürdün be sömürdün Google'ı! Nedir şu YouTube vidyolarının çektiği senden? Neyse ki hard diskin dolunca sorun kalmaz😛!")
            sys.exit()

        if is_valid_youtube_url(media_url):
            break

    download_folder = input("İndirilen medyanın kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"
    return media_url, download_folder

def download_media(url, download_folder):
    try:
        if 'list=' in url.lower():
            # Oynatma listesi URL'si algılandı
            playlist = Playlist(url)
            print(f"Oynatma Listesi Başlığı: {playlist.title}")

            for video in playlist.videos:
                selected_stream = get_video_quality(video)
                download_video(video, download_folder, selected_stream)
        else:
            # Video URL'si algılandı
            video = YouTube(url)
            selected_stream = get_video_quality(video)
            download_video(video, download_folder, selected_stream)
    except Exception as e:
        print(f"Hata oluştu: {e}")

def download_video(video, download_folder, selected_stream):
    print(f"Video Başlığı: {video.title}")
    print(f"Seçilen Çözünürlük: {selected_stream.resolution}")
    print(f"İndiriliyor...")

    selected_stream.download(download_folder)

    print(f"{video.title} indirme tamamlandı.\n")

def get_video_quality(video):
    available_streams = list(video.streams.filter(progressive=True, file_extension="mp4"))
    
    print("Mevcut Video Kaliteleri:")
    for i, stream in enumerate(available_streams, start=1):
        print(f"{i}. {stream.resolution} - {stream.mime_type}")

    selected_index = int(input("Lütfen indirmek istediğiniz video kalitesinin numarasını girin: "))
    selected_stream = available_streams[selected_index - 1]

    return selected_stream

def play_welcome_sound():
    welcome_sound = AudioSegment.from_wav("sound/start.wav")
    play_obj = sa.play_buffer(welcome_sound.raw_data, num_channels=welcome_sound.channels,
                              bytes_per_sample=welcome_sound.sample_width, sample_rate=welcome_sound.frame_rate)
    play_obj.wait_done()

def play_exit_sound():
    exit_sound = AudioSegment.from_wav("sound/exit.wav")
    play_obj = sa.play_buffer(exit_sound.raw_data, num_channels=exit_sound.channels,
                               bytes_per_sample=exit_sound.sample_width, sample_rate=exit_sound.frame_rate)
    play_obj.wait_done()

if __name__ == "__main__":
    media_url, download_folder = get_user_input()
    download_media(media_url, download_folder)
