import re
import os
from pytube import Playlist, YouTube

def clean_filename(filename):
    # Geçerli dosya adında kullanılamayan karakterleri temizle
    cleaned_filename = re.sub(r'[\\/:*?"<>|]', '', filename)
    return cleaned_filename

def is_playlist_url(url):
    playlist_identifiers = ['list=', 'playlist?']
    return any(identifier in url.lower() for identifier in playlist_identifiers)

def download_media(url, download_folder='C:/Programlarım/YTDown'):
    try:
        if is_playlist_url(url):
            # Oynatma listesi URL'si algılandı
            playlist = Playlist(url)
            playlist_title = playlist.title
            print(f"Oynatma Listesi Başlığı: {playlist_title}")

            # Oynatma listesi için klasörü oluştur
            playlist_folder = os.path.join(download_folder, clean_filename(playlist_title))
            os.makedirs(playlist_folder, exist_ok=True)

            for video in playlist.videos:
                download_video(video, playlist_folder)
        else:
            # Video URL'si algılandı
            video = YouTube(url)
            download_video(video, download_folder)
    except Exception as e:
        print(f"Hata oluştu: {e}")

def download_video(video, download_folder):
    print(f"Video Başlığı: {video.title}")

    # En yüksek çözünürlükteki videoyu bul
    highest_resolution_stream = video.streams.get_highest_resolution()

    if highest_resolution_stream:
        print(f"Çözünürlük: {highest_resolution_stream.resolution}")
        print(f"İndiriliyor...")

        # Videoyu oynatma listesi klasörüne indir
        video_path = os.path.join(download_folder, f"{clean_filename(video.title)}.{highest_resolution_stream.mime_type.split('/')[-1]}")
        highest_resolution_stream.download(video_path)
        print(f"{video.title} indirme tamamlandı.\n")
    else:
        print("Üzgünüm, belirtilen çözünürlükte bir video bulunamadı.\n")

if __name__ == "__main__":
    media_url = input("Lütfen indirmek istediğiniz medya (video/oynatma listesi) URL'sini girin: ")
    download_folder = input("İndirilen medyanın kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"

    download_media(media_url, download_folder)
