from pytube import Playlist, YouTube

def download_media(url, download_folder='C:/Programlarım/YTDown'):
    try:
        if 'playlist' in url.lower():
            # Oynatma listesi URL'si algılandı
            playlist = Playlist(url)
            print(f"Oynatma Listesi Başlığı: {playlist.title}")

            for video in playlist.videos:
                download_video(video, download_folder)
        else:
            # Video URL'si algılandı
            video = YouTube(url)
            download_video(video, download_folder)
    except Exception as e:
        print(f"Hata oluştu: {e}")

def download_video(video, download_folder):
    print(f"Video Başlığı: {video.title}")
    print(f"Çözünürlük: {video.streams.filter(file_extension='mp4', progressive=True).first().resolution}")
    print(f"İndiriliyor...")

    video.streams.filter(file_extension='mp4', progressive=True).first().download(download_folder)

    print(f"{video.title} indirme tamamlandı.\n")

if __name__ == "__main__":
    media_url = input("Lütfen indirmek istediğiniz medya (video/oynatma listesi) URL'sini girin: ")
    download_folder = input("İndirilen medyanın kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"

    download_media(media_url, download_folder)
