import yt_dlp

def search_and_download(query, download_folder):
    ydl_opts = {
        'format': 'mp4',
        'outtmpl': f'{download_folder}/%(title)s.%(ext)s',
    }  # MP4 video formatını seçer

    with yt_dlp.YoutubeDL(ydl_opts) as ydl:
        search_results = ydl.extract_info(f'ytsearch:{query}', download=False)

        # Arama sonuçlarını listeleme
        print("Arama Sonuçları:")
        for index, video_info in enumerate(search_results['entries'], start=1):
            title = video_info.get('title', 'Bilinmeyen Başlık')
            duration = video_info.get('duration', 'Bilinmeyen Süre')
            video_id = video_info.get('id', 'Bilinmeyen ID')
            print(f"{index}. {title} - {duration} - Video ID: {video_id}")

        # Kullanıcının hangi videoyu indirmek istediğini seçmesi için soru sorma
        selected_index = int(input("Lütfen indirmek istediğiniz video numarasını girin (Çıkış için 0): "))

        if selected_index == 0:
            print("İşlem iptal edildi.")
            return

        selected_video = search_results['entries'][selected_index - 1]

        print(f"Seçilen video: {selected_video['title']}")
        print(f"Video ID: {selected_video['id']}")

        # Videoyu indirme
        try:
            ydl.download([selected_video['id']])
            print("İndirme tamamlandı.")
        except Exception as e:
            print(f"Hata oluştu: {e}")

if __name__ == "__main__":
    search_query = input("Lütfen indirmek istediğiniz video adını veya anahtar kelimeyi girin: ")
    download_folder = input("İndirilen videonun kaydedileceği klasörü girin (Varsayılan: ./): ") or "./"

    search_and_download(search_query, download_folder)
